#pragma once

#include <util/generic/vector.h>
#include <util/network/ip.h>

namespace NSrvKernel::NSrcrwr {

struct TAddr {
    TAddr() {}
    TAddr(TString host, TString ip, TIpPort port) : Host(std::move(host)), Ip(std::move(ip)), Port(port) {}
    TString Host;
    TString Ip;
    TIpPort Port = 0;
};

class TAddrs {
public:
    void SetAddrs(TVector<TAddr> addrs);
    bool GetNextAddr(TString& host, TString& ip, TIpPort& port);
    bool GetAddr(TString& host, TString& ip, TIpPort& port);
    bool Empty() const;

private:
    TVector<TAddr> Addrs_;
    uint64_t Next_ = 0;
};

}
