#pragma once

#include "srcrwr_helper_i.h"


namespace NSrvKernel::NSrcrwr {

class THelper : public IHelper {
public:
    bool WriteHeader(TRequest& request, const TString& id) const override;
    bool GetAddrs(const TRequest& request, const TString& id, TVector<TAddr>& addrs) const noexcept override;

private:
    // Get "srcrwr_id:IP:port" strings for this ID
    TString GetParamFromCgi(const TRequest& request, const TString& id) const;
    // Read srcrwr addresses from CGI for this ID
    bool GetSrcAddresses(const TRequest& request, const TString& id, TVector<TAddr>& addrs) const;
    // Is id match "srcrwr_id:IP:port,hostname:port,..." string
    bool CheckId(const TString& id, const TString& cgiParam) const;
};

}