#pragma once

#include <util/generic/fwd.h>
#include <util/network/ip.h>

namespace NSrvKernel {
class TRequest;

namespace NSrcrwr {
struct TAddr;

//! HTTP helper for srcrwr. Encapsulates details of HTTP header handling.
class IHelper {
public:
    virtual ~IHelper() = default;

    //! Add srcrwr field to header. Returns false, if srcrwr field is already present, or doesn't match id.
    virtual bool WriteHeader(TRequest& request, const TString& id) const = 0;

    //! Get srcrwr addresses for this ID from CGI, if it is a correct srcrwr request
    virtual bool GetAddrs(const TRequest& request, const TString& id, TVector<TAddr>& addrs) const noexcept = 0;
};

}}