#include "sslextdataindeces.h"

namespace NSrvKernel {
    void SetSslTicketKeysData(ssl_ctx_st* ctx, void* data) noexcept {
        // Default<TSslTicketKeysIndex> is the singleton which is represents unique
        // index for OpenSSL. Here we creates something like mapping where key is
        // the OpenSSL context which was created in TSslItem ctor and value is pointer
        // to the parent TSslItem.
        if (SSL_CTX_set_ex_data(ctx, Default<TSslTicketKeysIndex>().Idx, data) == 0) {
            Y_FAIL("SSL_CTX_set_ex_data");
        }
    }

    void SetSslKeylogData(ssl_ctx_st* ctx, void* data) noexcept {
        if (SSL_CTX_set_ex_data(ctx, Default<TSslKeylogIndex>().Idx, data) == 0) {
            Y_FAIL("SSL_CTX_set_ex_data");
        }
    }

    ssl_ctx_st* GetSslCtx(const ssl_st* ssl) noexcept {
        return SSL_get_SSL_CTX(ssl);
    }

    void* GetSslTicketKeysData(ssl_ctx_st* ctx) noexcept {
        return SSL_CTX_get_ex_data(ctx, Default<TSslTicketKeysIndex>().Idx);
    }

    void* GetSslKeylogData(ssl_ctx_st* ctx) noexcept {
        return SSL_CTX_get_ex_data(ctx, Default<TSslKeylogIndex>().Idx);
    }
}
