#pragma once

#include <util/generic/yexception.h>

#include <openssl/ssl.h>

namespace NSrvKernel {
    /*
     * Base class for singleton with OpenSSL index
     */
    struct TSslTicketKeysIndex {
        TSslTicketKeysIndex()
            : Idx(SSL_CTX_get_ex_new_index(0, nullptr, nullptr, nullptr, nullptr))
        {
            if (Idx == -1) {
                Y_FAIL("SSL_CTX_get_ex_new_index");
            }
        }

        const int Idx;
    };

    struct TSslKeylogIndex {
        TSslKeylogIndex()
                : Idx(SSL_CTX_get_ex_new_index(0, nullptr, nullptr, nullptr, nullptr))
        {
            if (Idx == -1) {
                Y_FAIL("SSL_CTX_get_ex_new_index");
            }
        }

        const int Idx;
    };

    /**
     * Get parent ssl context
     *
     * @param[in] ssl                    OpenSSL info struct
     */
    ssl_ctx_st* GetSslCtx(const ssl_st* ssl) noexcept;
    /**
     * Get parent ssl context
     *
     * @param[in] ctx                    OpenSSL context
     * @param[in] data                   pointer to TSslItem
     */
    void SetSslTicketKeysData(ssl_ctx_st* ctx, void* data) noexcept;
    /**
     * Set TSslItem item idx for keylog
     *
     * @param[in] ctx                    OpenSSL context
     * @param[in] data                   pointer to TSslItem
     */
    void SetSslKeylogData(ssl_ctx_st* ctx, void* data) noexcept;
    /**
     * Return pointer to TSslItem
     *
     * @param[in] ctx                    OpenSSL context
     *
     * @return                           pointer to TSslItem
     */
    void* GetSslTicketKeysData(ssl_ctx_st* ctx) noexcept;
    /**
     * Return pointer to TSslItem for keylog
     *
     * @param[in] ctx                    OpenSSL context
     *
     * @return                           pointer to TSslItem
     */
    void* GetSslKeylogData(ssl_ctx_st* ctx) noexcept;
}
