#include <balancer/kernel/ssl/ssl_client_ctx_storage.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>


using namespace NSrvKernel;

const TString Ciphers1 = "kEECDH:kRSA+AES128:kRSA:+3DES:RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2";
const TString Ciphers2 = "kRSA:+3DES:RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2";
const TString CaFile1 = ArcadiaSourceRoot() + "/balancer/kernel/ssl/ut/certs/GlobalSign_Root_CA_-_R6.pem";
const TString NotCaFile1 = ArcadiaSourceRoot() + "/balancer/kernel/ssl/ut/ssl_client_ctx_storage_ut.cpp";


Y_UNIT_TEST_SUITE(TSslClientCtxStorageTest) {
    Y_UNIT_TEST(CorrectContextIsCreated) {
        auto ptr = GetSslClientContext(Ciphers1, 1, CaFile1);
        UNIT_ASSERT(ptr);
    }

    Y_UNIT_TEST(InvalidContextIsNotCreated) {
        UNIT_ASSERT_EXCEPTION(GetSslClientContext("qwerty", 1, CaFile1), yexception);
        UNIT_ASSERT_EXCEPTION(GetSslClientContext(Ciphers1, 1, NotCaFile1), yexception);
    }

    Y_UNIT_TEST(CorrectContextsReused) {
        auto ptr_c1_1 = GetSslClientContext(Ciphers1, 1, CaFile1);
        UNIT_ASSERT(ptr_c1_1);
        auto ptr_c1_2 = GetSslClientContext(Ciphers1, 1, CaFile1);
        UNIT_ASSERT(ptr_c1_1.Get() == ptr_c1_2.Get());

        auto ptr_c2_1 = GetSslClientContext(Ciphers2, 1, CaFile1);
        UNIT_ASSERT(ptr_c2_1 && ptr_c2_1.Get() != ptr_c1_1.Get());

        auto ptr_d2 = GetSslClientContext(Ciphers1, 2, CaFile1);
        UNIT_ASSERT(ptr_d2 && ptr_d2.Get() != ptr_c1_1.Get());

        auto ptr_c1_3 = GetSslClientContext(Ciphers1, 1, CaFile1);
        UNIT_ASSERT(ptr_c1_3 && ptr_c1_3.Get() == ptr_c1_1.Get());
    }
}