#pragma once

#include <library/cpp/monlib/encode/json/json.h>
#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/monlib/metrics/metric_type.h>
#include <library/cpp/monlib/metrics/metric.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <utility>

namespace NSrvKernel {

struct TCounter {
    TString Name;
    ui64 Value;
    TString Sigopt;
    NMonitoring::EMetricType MetricType;
    NMonitoring::TLabels Labels;
};

struct THistogram {
    TString Name;
    TVector<std::pair<double, ui64>> Values;
    TString Sigopt;
    NMonitoring::EMetricType MetricType;
    NMonitoring::TLabels Labels;
};

struct TBalancerStats {
    TVector<TCounter> Counters;
    TVector<THistogram> Histograms;
};

void EncodeSolomonResponse(NMonitoring::IMetricEncoderPtr& encoder, const TBalancerStats& stats);

}  // namespace NSrvKernel

