#include <balancer/kernel/stats/manager.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(TTestCombinedCounter) {
    Y_UNIT_TEST(TestCreation) {
        TAtomic val = 0;
        TSharedCounter counter(&val);
        counter.Set(0);

        TCombinedCounter cc;
        cc.SetSharedCounter(std::move(counter));
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 0);
    }

    Y_UNIT_TEST(TestCreationWithoutSharedCounter) {
        TCombinedCounter cc;
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 0);
    }

    Y_UNIT_TEST(TestModificationWithoutSharedCounter) {
        TCombinedCounter cc;

        ++cc;
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 1);
        --cc;
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 0);

        cc += 239;
        cc -= 123;
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 239 - 123);
    }

    Y_UNIT_TEST(TestAssignmentAndModification) {
        TCombinedCounter cc;

        TAtomic val = 0;
        TSharedCounter counter(&val);
        counter.Set(123);

        cc.SetSharedCounter(std::move(counter));
        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 123);

        cc.Add(566);

        UNIT_ASSERT_VALUES_EQUAL(cc.Value(), 123 + 566);
    }

    Y_UNIT_TEST(TestCounterReassignment) {
        TCombinedCounter cc;

        TAtomic val = 239;
        TSharedCounter counter(&val);

        TAtomic val2 = 566;
        TSharedCounter counter2(&val2);

        cc.SetSharedCounter(std::move(counter));

        cc += 101;

        UNIT_ASSERT_EXCEPTION(cc.SetSharedCounter(std::move(counter2)), yexception);
    }
}
