#pragma once

#include <util/datetime/base.h>

namespace NSrvKernel {

class IThreadTimeArbiter {
public:
    virtual ~IThreadTimeArbiter() = default;

protected:
    friend class TThreadTimeManager;

    virtual void SleepUntil(TInstant tp) noexcept = 0;

    virtual TInstant Now() const noexcept = 0;
};

class TThreadTimeArbiter final : public IThreadTimeArbiter {
private:
    virtual void SleepUntil(TInstant tp) noexcept override {
        return ::SleepUntil(tp);
    }

    virtual TInstant Now() const noexcept override {
        return ::Now();
    }
};

}  // namespace NSrvKernel
