#include "time_manager.h"
#include "time_arbiter.h"

namespace NSrvKernel {

TThreadTimeManager::TThreadTimeManager() noexcept
    : TimeArbiter_(MakeHolder<TThreadTimeArbiter>())
{}

TThreadTimeManager::~TThreadTimeManager() = default;

void TThreadTimeManager::SleepUntil(TInstant tp) const noexcept {
    TimeArbiter_->SleepUntil(tp);
}

TInstant TThreadTimeManager::Now() const noexcept {
    return TimeArbiter_->Now();
}


TThreadTimeManager::TMockGuard::TMockGuard(THolder<IThreadTimeArbiter> mock) noexcept
    : PrevArbiter_(std::move(TThreadTimeManager::Instance().TimeArbiter_))
{
    TThreadTimeManager::Instance().VerifyTesting();
    TThreadTimeManager::Instance().TimeArbiter_ = std::move(mock);
}

TThreadTimeManager::TMockGuard::~TMockGuard() {
    TThreadTimeManager::Instance().TimeArbiter_ = std::move(PrevArbiter_);
}

}  // namespace NSrvKernel
