#include "tvm.h"

namespace NSrvKernel {
    NTvmAuth::TTvmClient& TClientMap::GetClient(NTvmAuth::TTvmId clientId) {
        auto ptr = Clients_.find(clientId);
        if (ptr != Clients_.end()) {
            return ptr->second;
        }

        NTvmAuth::NTvmApi::TClientSettings settings;
        settings.SetSelfTvmId(clientId);
        settings.EnableServiceTicketChecking();

        Clients_.emplace(
                clientId,
                NTvmAuth::TTvmClient(settings, NTvmAuth::TDevNullLogger::IAmBrave())
        );

        return Clients_.find(clientId)->second;
    }
};