#include "template.h"

#include <library/cpp/archive/yarchive.h>

#include <util/generic/singleton.h>

namespace NModAntiDDOS {
    static const unsigned char templates_data[] = {
        #include "templates.inc"
    };

    class TTemplatesArchive: public TArchiveReader {
    public:
        TTemplatesArchive()
            : TArchiveReader(TBlob::NoCopy(templates_data, sizeof(templates_data)))
        {
        }
    };

    static inline TArchiveReader& TemplateArchive() {
        return *Singleton<TTemplatesArchive>();
    }

    THolder<IInputStream> GetTemplate(const TString& name) {
        return TemplateArchive().ObjectByKey("/" + name);
    }
}
