#pragma once

#include <balancer/kernel/http/parser/httpdecoder.h>
#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/module/iface.h>

#include <library/cpp/regex/pire/regexp.h>

#include <util/generic/ylimits.h>

namespace NModAntiRobot {

const TStringBuf ANTIROBOT_HEADERS[] = {
    "X-Yandex-Internal-Request",
    "X-Yandex-Suspected-Robot",
    "X-Antirobot-Robotness-Y",
    "X-Antirobot-Suspiciousness-Y",
    "X-Antirobot-Is-Crawler",
    "X-Yandex-Antirobot-Degradation",
    "X-SuggestRobot-Y",
    "X-Antirobot-Experiments",
    "X-Antirobot-Default-Path",
    "X-Antirobot-Jws-Info",
    "X-Yandex-EU-Request"
};

class TChecker {
public:
    TChecker(NSrvKernel::IModule* submodule, const NSrvKernel::TConnDescr& descr, const NSrvKernel::TRequest& request,
             size_t cutRequestBytes, bool wrapper, bool cutRequest) noexcept;

    [[nodiscard]] NSrvKernel::TError Run() noexcept;

    bool IsRobot() const noexcept {
        return IsRobot_;
    }

    bool ShouldBan() const noexcept {
        return ShouldBan_;
    }

    bool SentRedirect() const noexcept {
        return SentRedirect_;
    }

    NSrvKernel::TResponse& AntirobotResponse() noexcept {
        return Response_;
    }

private:
    [[nodiscard]] NSrvKernel::TError RunForRequest(NSrvKernel::TRequest request,
                                                   NSrvKernel::IIoInput& body) noexcept;

    [[nodiscard]] NSrvKernel::TError RunCutRequest(NSrvKernel::TChunkList requestChunks) noexcept;

    [[nodiscard]] NSrvKernel::TError RunFullRequest(NSrvKernel::TChunkList requestChunks) noexcept;

private:
    NSrvKernel::IModule* Submodule_ = nullptr;
    const NSrvKernel::TConnDescr& Descr_;
    NSrvKernel::TResponse Response_; // response from antirobot
    const NSrvKernel::TRequest& Request_; // antirobot request
    size_t CutRequestBytes_ = Max<size_t>();
    const bool Wrapper_ = false;
    const bool CutRequest_ = false; // TODO: change this default after 32 release
    bool IsRobot_ = false;
    bool SentRedirect_ = false;
    bool ShouldBan_ = false;
};

}  // namespace NModAntiRobot
