#include "backends_factory.h"

#include "active.h"
#include "by_location.h"
#include "consistent_hashing.h"
#include "dynamic/wrr.h"
#include "dynamic/hashing.h"
#include "hashing.h"
#include "leastconn.h"
#include "pwr2.h"
#include "rendezvous_hashing.h"
#include "rrobin.h"
#include "weighted2.h"

namespace NSrvKernel {
    const INodeFactory<IBackends>* CommonBackends() {
        struct TFactory : public TNodeFactory<IBackends> {
            TFactory() {
                using namespace NModBalancer;

                AddHandle(NActive::Handle());
                AddHandle(NByLocation::Handle());
                AddHandle(NHashing::Handle());
                AddHandle(NHashing::Handle(), "subnet");
                AddHandle(NRRobin::Handle());
                AddHandle(NWeighted2::Handle());
                AddHandle(NConsistentHashing::Handle());
                AddHandle(NLeastConn::Handle());
                AddHandle(NPowerOfTwoChoices::Handle());
                AddHandle(NRendezvousHashing::Handle());
                AddHandle(NDynamic::HandleWrr());
                AddHandle(NDynamic::HandleHashing());
            }
        };

        return &Default<TFactory>();
    }
}  // namespace NSrvKernel
