#pragma once

#include <balancer/kernel/balancer/backends.h>
#include <balancer/kernel/balancer/policy.h>
#include <balancer/kernel/process/config_check.h>
#include <balancer/modules/service_discovery/sd.h>


namespace NModBalancer {
    class TEntities {
    public:
        explicit TEntities(TString errorPrefix, NBalancerSD::TBackendsInitializationParams::TConfigMaker configMaker = NBalancerSD::MakeConfig);
        void ApplyConfiguration(const NSrvKernel::TModuleParams& mp, const NSrvKernel::TBackendCheckParameters& checkParams = {});
        void Configure(const TString& key, const NSrvKernel::TModuleParams& mp);
        void Init(NSrvKernel::IWorkerCtl* process, THolder<NBalancerSD::TWorkerBackendsRef>& backendsRef);
        void Dispose(NSrvKernel::IWorkerCtl* process, THolder<NBalancerSD::TWorkerBackendsRef>& backendsRef);

        NSrvKernel::IBackends* Backends() const noexcept;
        const TString& BackendsType() const noexcept;
        NSrvKernel::IPolicyFactory* PolicyFactory() const noexcept;
        NBalancerSD::TBackendsProvider* BackendsProvider() const noexcept;
    private:
        TString ErrorPrefix_;
        NBalancerSD::TBackendsInitializationParams::TConfigMaker ConfigMaker_;
        THolder<NSrvKernel::IBackends> Backends_;
        THolder<NBalancerSD::TBackendsProvider> SD_;
        NSrvKernel::TBackendsUID BackendsUID_;

        TString BackendsType_;
        THolder<NSrvKernel::IPolicyFactory> PolicyFactory_;
    };
}
