#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NActive {

class TActivePolicy : public IPolicy {
public:
    explicit TActivePolicy(THolder<IPolicy> slave, size_t skipAttempts) noexcept
        : Slave_(std::move(slave))
        , SkipAttempts_(skipAttempts)
    {}

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void RegisterSuccess() noexcept override {
        Slave_->RegisterSuccess();
    }

    void RegisterFail() noexcept override {
        Slave_->RegisterFail();
    }

    void MarkAsRetry() noexcept override {}

private:
    THolder<IPolicy> Slave_;
    size_t SkipAttempts_ = std::numeric_limits<size_t>::max();
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NActive
