#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NBackOff {

class TBackOffPolicy : public IPolicy {
public:
    explicit TBackOffPolicy(const TVector<double>& probabilities, THolder<IPolicy> slave) noexcept
        : Probabilities_(probabilities)
        , Slave_(std::move(slave))
    {}

    IBackend* BackoffDoNext(IAlgorithm* algo, double probability, bool fastAttempt) noexcept;

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void MarkAsRetry() noexcept override {
        Attempt_++;
    }

    void RegisterSuccess() noexcept override {
        Slave_->RegisterSuccess();
    }

    void RegisterFail() noexcept override {
        Slave_->RegisterFail();
    }

private:
    const TVector<double>& Probabilities_;
    THolder<IPolicy> Slave_;
    size_t Attempt_ = 0;
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NBackOff
