#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NByHash {

class TByHashPolicy : public IPolicy {
public:
    TByHashPolicy(THolder<IPolicy> slave, const TStepParams& params) noexcept
        : Slave_(std::move(slave))
        , Descr_(*params.Descr)
    {}

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void MarkAsRetry() noexcept override {
        First_ = false;
    }

private:
    THolder<IPolicy> Slave_;
    const TConnDescr& Descr_;
    bool First_ = true;
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NByHash
