#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NByName {

struct TByNameOptions {
    bool Strict = false;
    bool AllowZeroWeights = false;
};

class TByNamePolicy : public IPolicy {
public:
    TByNamePolicy(TString name, THolder<IPolicy> slave, TByNameOptions opts) noexcept
        : Name_(std::move(name))
        , Slave_(std::move(slave))
        , Opts_(opts)
    {}

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void MarkAsRetry() noexcept override {
        First_ = false;
    }

private:
    TString Name_;
    THolder<IPolicy> Slave_;
    bool First_ = true;

    const TByNameOptions Opts_;
};


class TByNamePolicyFactoryBase {
public:
    bool ConsumeOpts(const TString& key, NConfig::IConfig::IValue* value);

protected:
    TByNameOptions Opts_;
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NByName
