#include "simple.h"
#include "unique.h"
#include "retry.h"
#include "unique_retry.h"
#include "watermark.h"
#include "timeout.h"
#include "active.h"
#include "by_name.h"
#include "by_hash.h"
#include "back_off.h"
#include "by_name_from_header.h"
#include "by_group_name_from_header.h"

namespace NSrvKernel {

const INodeFactory<IPolicyFactory>* PolicyFactories() {
    struct TFactory: public TNodeFactory<IPolicyFactory> {
        TFactory() {
            AddHandle(NSimple::Handle());
            AddHandle(NUnique::Handle());
            AddHandle(NRetry::Handle());
            AddHandle(NUniqueRetry::Handle());
            AddHandle(NWatermark::Handle());
            AddHandle(NTimeout::Handle());
            AddHandle(NActive::Handle());
            AddHandle(NByName::Handle());
            AddHandle(NByHash::Handle());
            AddHandle(NBackOff::Handle());
            AddHandle(NByNameFromHeader::Handle());
            AddHandle(NByGroupNameFromHeader::Handle());
        }
    };

    return &Default<TFactory>();
}

}  // namespace NSrvKernel
