#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NRetry {

class TRetryPolicy : public IPolicy {
public:
    explicit TRetryPolicy(THolder<IPolicy> slave) noexcept
        : Slave_(std::move(slave))
    {}

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void RegisterSuccess() noexcept override {
        Slave_->RegisterSuccess();
    }

    void RegisterFail() noexcept override {
        Slave_->RegisterFail();
    }

    void MarkAsRetry() noexcept override {}

private:
    THolder<IPolicy> Slave_;
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NRetry
