#include "simple.h"

#include <balancer/kernel/balancer/algorithm.h>
#include <balancer/kernel/balancing/backend.h>
#include <balancer/modules/balancer/policies/policy_factory.h>

namespace NSrvKernel::NSimple {

IBackend* TSimplePolicy::Next(IAlgorithm* algo, bool) noexcept {
    return algo->SelectNext();
}


POLICY_FACTORY(simple_policy) {
    TPolicyFactory(const TModuleParams&) {}

    THolder<IPolicy> ConstructPolicy(const TStepParams&) noexcept override {
        return MakeHolder<TSimplePolicy>();
    }

    void FillFeatures(TPolicyFeatures&) const noexcept override {}

    void Init(IWorkerCtl*) override {}
};

INodeHandle<IPolicyFactory>* Handle() {
    return TPolicyFactory::Handle();
}

}  // namespace NSrvKernel::NSimple
