#include "unique.h"

#include <balancer/kernel/balancer/algorithm.h>
#include <balancer/kernel/balancing/backend.h>
#include <balancer/modules/balancer/policies/policy_factory.h>

namespace NSrvKernel::NUnique {

IBackend* TUniquePolicy::Next(IAlgorithm* algo, bool) noexcept {
    IBackend* next = algo->Next();
    if (next != nullptr) {
        algo->RemoveSelected(next);
    }
    return next;
}


POLICY_FACTORY(unique_policy) {
    TPolicyFactory(const TModuleParams&) {}

    THolder<IPolicy> ConstructPolicy(const TStepParams&) noexcept override {
        return MakeHolder<TUniquePolicy>();
    }

    void FillFeatures(TPolicyFeatures&) const noexcept override {}

    void Init(IWorkerCtl*) override {}
};

INodeHandle<IPolicyFactory>* Handle() {
    return TPolicyFactory::Handle();
}

}  // NSrvKernel::NUnique
