#pragma once

#include <balancer/kernel/balancer/policy.h>

namespace NSrvKernel::NUniqueRetry {

struct TUniqueRetryOptions {
    ui32 ResetsCount = Max<ui32>();
};

class TUniqueRetryPolicy : public IPolicy {
public:
    explicit TUniqueRetryPolicy(const TUniqueRetryOptions& opts) noexcept
        : Opts_(opts)
    {}

    IBackend* Next(IAlgorithm* algo, bool fastAttempt) noexcept override;

    void MarkAsRetry() noexcept override {}

private:
    IBackend* DoNext(IAlgorithm* algo) noexcept;

private:
    TUniqueRetryOptions Opts_;
};

INodeHandle<IPolicyFactory>* Handle();

}  // namespace NSrvKernel::NUniqueRetry
