#pragma once

#include <balancer/kernel/fs/kv_file_consumer.h>
#include <balancer/kernel/fs/shared_file_rereader.h>
#include <library/cpp/json/json_writer.h>
#include <util/generic/strbuf.h>

namespace NSrvKernel {
class IWorkerCtl;
class TConnDescr;
}

namespace NSrvKernel::NModBalancer {

class TExternalWeightsFileReReader {
public:
    using TEntries = TExternalWeightsFileReaction::TStorage;
    TExternalWeightsFileReReader(IWorkerCtl& process, TString weightsFile, TDuration interval, TString name) noexcept;
    TExternalWeightsFileReReader() = default;
    bool UpdateWeights(const TConnDescr& descr) noexcept;
    const TEntries& Entries() const noexcept {
        return Entries_;
    }
    const TSharedFileReReader::TData& LatestData() const noexcept {
        return ReReader_.Data();
    }
    // WriteWeightsFileTag dumps information about weights file and its tag in given TJsonWriter in a unified manner.
    void WriteWeightsFileTag(NJson::TJsonWriter& out) const noexcept;
private:
    TString FileName_;
    TSharedFileReReader ReReader_;
    size_t Id_ = 0;
    TEntries Entries_;
    TMaybe<TString> Tag_;
    TString Name_;
};

} // namespace NSrvKernel::NModBalancer
