LIBRARY()

OWNER(g:balancer)

PEERDIR(
    contrib/libs/xxhash
    balancer/kernel/balancer
    balancer/kernel/balancing
    balancer/kernel/coro
    balancer/kernel/ctl
    balancer/kernel/custom_io
    balancer/kernel/fs
    balancer/kernel/http/parser
    balancer/kernel/log
    balancer/kernel/memory
    balancer/kernel/module
    balancer/kernel/pinger
    balancer/kernel/requester
    balancer/kernel/thread
    balancer/modules/balancer/policies
    balancer/modules/service_discovery
    contrib/libs/highwayhash
    library/cpp/consistent_hash_ring
    library/cpp/containers/intrusive_avl_tree
    library/cpp/containers/intrusive_rb_tree
)

SRCS(
    active.cpp
    backends_factory.cpp
    base_algorithm.cpp
    by_location.cpp
    consistent_hashing.cpp
    dynamic/core.cpp
    entities.cpp
    hashing.cpp
    leastconn.cpp
    module.cpp
    pwr2.cpp
    rate_limiter.cpp
    rendezvous_hashing.cpp
    rrobin.cpp
    weighted2.cpp
    weights_file.cpp
)

END()

RECURSE_FOR_TESTS(
    policies
    ut
)
