#pragma once

#include <util/datetime/base.h>

#include <balancer/kernel/memory/chunks.h>
#include <balancer/kernel/regexp/regexp_pire.h>

namespace NCache {

struct TRFC1123Date {
    using TParseException = TDateTimeParseException;

    static TInstant ParseValue(TStringBuf value) {
        return TInstant::ParseHttpDeprecated(value);
    }

    static TString Value(const TInstant& time) noexcept {
        return time.ToRfc822String();
    }
};

struct TIfModifiedSince: public NSrvKernel::TFsm, public TRFC1123Date {
    TIfModifiedSince() noexcept
        : NSrvKernel::TFsm("If-Modified-Since", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "If-Modified-Since";
    }
};

struct TLastModified: public NSrvKernel::TFsm, public TRFC1123Date {
    TLastModified() noexcept
        : NSrvKernel::TFsm("Last-Modified", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "Last-Modified";
    }
};

struct TValidUntil: public NSrvKernel::TFsm, public TRFC1123Date {
    TValidUntil() noexcept
        : NSrvKernel::TFsm("Valid-Until", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "Valid-Until";
    }
};

struct TIfNoneMatch: public NSrvKernel::TFsm {
    TIfNoneMatch() noexcept
        : NSrvKernel::TFsm("If-None-Match", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "If-None-Match";
    }
};

struct TCacheAction: public NSrvKernel::TFsm {
    TCacheAction() noexcept
        : NSrvKernel::TFsm("Cache-Action", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "Cache-Action";
    }
};

struct TETag: public NSrvKernel::TFsm {
    TETag() noexcept
        : NSrvKernel::TFsm("ETag", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Key() noexcept {
        return "ETag";
    }
};

struct TValidate: public NSrvKernel::TFsm {
    TValidate() noexcept
        : NSrvKernel::TFsm("Validate", NSrvKernel::TFsm::TOptions().SetCaseInsensitive(true))
    {}

    static auto Value() noexcept {
        return "Validate";
    }
};

}
