#pragma once

#include <search/cache/memory_cacher.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>


class IInputStream;
class IOutputStream;

namespace NSrvKernel {
    class IIoInput;
    class IIoOutput;
    class TThreadedQueue;
}

namespace NCache {

struct IMeta {
    virtual void Load(IInputStream* in) = 0;
    virtual void Store(IOutputStream* out) = 0;
};

THolder<NSrvKernel::IIoInput> Load(TReqCacher* cacher, IMeta* meta, NSrvKernel::TThreadedQueue* queue, TInstant deadline, const TString& id);
THolder<NSrvKernel::IIoOutput> Store(TReqCacher* cacher, IMeta* meta, NSrvKernel::TThreadedQueue* queue, TInstant deadline, const TString& id);

bool MakeSpace(TMemoryCacher* cacher, NSrvKernel::TThreadedQueue* queue, TInstant deadline, const TString& id, size_t size);

}
