#include <balancer/modules/cache/fixed_size_encode.h>

#include <balancer/kernel/http/parser/response_builder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NSrvKernel;

Y_UNIT_TEST_SUITE(FixedSizeEncodeTest) {
    constexpr TStringBuf BODY_SAMPLE = "some body";

    Y_UNIT_TEST(SmokingTest) {
        TResponse response = BuildResponse().Version11().Code(HTTP_OK);
        auto body = TChunkList{TString{BODY_SAMPLE}};
        auto encoded = ToString(FixedSizeEncode(std::move(response), std::move(body)));
        UNIT_ASSERT_UNEQUAL(encoded.find("Content-Length: " + ToString(BODY_SAMPLE.size())),
                            TString::npos);
    }
}
