#pragma once

using namespace NSrvKernel;
using namespace NSrvKernel::NStorage;

#include "helpers.h"

class TCacheStrategyResult {
public:
    bool ShouldFlushToCache = true;
    bool GetFromCache = true;
};

class TCacheProcessor {
public:
    TCacheProcessor(bool ignoreCacheControl)
    : IgnoreCacheControl_(ignoreCacheControl)
    {
    }
public:
    TCacheStrategyResult ProcessRequest (const TRequest& re) {
        TCacheStrategyResult res;

        auto c = CacheHelpers::PreprocessHeaders(re, IgnoreCacheControl_);

        if (c.CacheControlNoStore) {
            res.ShouldFlushToCache = false;
        }

        if (c.CacheControlNoCache) {
            res.GetFromCache = false;
        }

        if (re.RequestLine().Method != EMethod::GET) {
           res.GetFromCache = false;
           res.ShouldFlushToCache = false;
        }

        return res;
    }

    void UpdateStrategyProcessingException (TCacheStrategyResult* strategy) {
        strategy->ShouldFlushToCache = false;
    }

    void UpdateStrategyProcessingResponse (const TResponse& re, TCacheStrategyResult* strategy) {
        if (!CacheHelpers::MayStoreInCache(re, IgnoreCacheControl_)) {
            strategy->ShouldFlushToCache = false;
        }
    }
private:
    bool IgnoreCacheControl_ = true;
};

