#pragma once

#include <balancer/kernel/memory/chunks.h>
#include <balancer/kernel/regexp/regexp_re2.h>

#include <util/generic/maybe.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NModCgiHasher {
    class ICgiHasher {
    public:
        enum class EMode {
            Concatenated /* "concatenated" */,
            Priority /* "priority" */
        };

        struct TOpts {
            EMode Mode = EMode::Concatenated;
            bool CaseInsensitive = false;
        };

    public:
        virtual ~ICgiHasher() = default;

        virtual TMaybe<ui64> Calc(TStringBuf /*cgi*/) const noexcept = 0;
    };

    THolder<ICgiHasher> MakeHasher(TVector<TString> params, ICgiHasher::TOpts opts);
}
