## Модуль для работы с куками в запросах и ответах.

https://wiki.yandex-team.ru/balancer/cookbook/cookiepolicy/

В `common` лежит общий код и описание конфига, в `policies` - правила, применяемые к кукам. Поддерживаются файловые ручки (см. описание в конфиге).

### Компоненты

#### Общий код в common
* Парсит куки
* Опционально удаляет невалидные `Set-Cookie`
* Определяет GDPR-статус пользователя
* Мониторит файловые ручки
    * включения политик
    * внутренних флагов GDPR
* Генерирует логи и метрики

#### Политики в policies
* `session_lifetime` - форсирует сессионность: удаляет `Expires` и `Max-Age` для кук, которые сами не являются удалениями
* `persistent_lifetime` - форсирует персистентность: запрещает выставлять куки без явных `Expires`/`Max-Age`. Можно задавать ограничения по времени жизни кук - в этом случае делает поправку на GDPR.
* `global_scope` - исправляет `Path` и `Domain` на максимально широкие.
* `http_only_false` - удаляет флаг `HttpOnly`.
* `secure_true` - выставляет флаг `Secure`. Можно выставлять ограничения по доменам.
* `samesite_none` - исправляет выставление `SameSite=None` в зависимости от `User-Agent`. Можно форсировать `SameSite=None` для отдельных кук.
* `cookie_value` - может валидировать значение выставляемой бэкендом куки относительно регулярки, запретить удалять куку и запретить менять значение куки.
* `protected_cookie` - запрещает любые `Set-Cookie` с данной кукой. Можно выставлять ограничения по доменам.
* `is_gdpr_cookie` - выставляет куку `is_gdpr`, см ниже.
* `is_gdpr_b_cookie` - выставляет куку `is_gdpr_b`, см ниже.
* `gdpr_client_cookie` - удаляет нарушающие GDPR куки с клиента. При этом
    * не делает предположений относительно доменов и путей, на которые выставлена кука. На клиенте кука идентифицируется тройкой имя-домен-путь, удалить её можно либо зная правильные домен и путь, либо перебрав все, что и делает эта политика.
    * при переборе доменов и путей соблюдает ограничения на число генерируемых заголовков `Set-Cookie`.
* `gdpr_server_cookie` - блокирует выставление нарушающих GDPR кук бэкендом
* `gdpr_lifetime` - ограничивает время жизни выставляемых бэкендом кук 2 годами.

### GDPR

Цель - форсировать соблюдение GDPR в плане кук, не нанеся ущерба UX и трекингу за пределами GDPR.

Управляется 4 куками
* `gdpr` - содержит выбор пользователя при показе GDPR-плашки. Выставляется метрикой скриптом на клиенте.
* `gdpr_popup` - факт показа плашки пользователю. Позволяет различать ситуации, когда пользователь ничего не выбрал и когда мы ему ничего не показали. Выставляется метрикой скриптом на клиенте.
* `is_gdpr_b` - внутренняя кука балансера, пробрасывает пробрасывать информацию о геолокации пользователя с балансеров L7 на балансеры AWACS, а также хранит последнюю геолокацию пользователя без VPN. Выставляется балансером. 

    Содержит протобуф в base64, внутри - 4 поля:
    * `BalancerVerHash` - хэш от версии балансера, выставившего куку,
    * `TstampHours` - таймстемп выставления, округленный до часа.
    * `IsGdpr` - флаг, входил ли регион пользователя в GDPR на момент выставления куки
    * `IsGdprNoVpn` - опциональный флаг принадлежности региона пользователя GDPR на момент последнего захода без VPN.
    
    `BalancerVerHash` и `TstampHours` используются для отслеживания истории и как способ быстрой отмены ошибочных установок `is_gdpr_b` (можно заблокировать плохие куки на балансерах).
* `is_gdpr` - флаг принадлежности пользователя GDPR зоне. На балансере не используется, предназначен исключительно для бэкендов. Выставляется балансером.

Информация о GDPR-статусе локации пользователя может получаться из следующих источников:
* кука `is_gdpr_b`, выставляется балансерами L7.
* заголовок `X-Yandex-EU-Request`, присылается антироботом. Балансеры L7 используют его как один из источников данных для куки `is_gdpr_b`.
* заголовок `X-Ip-Properties`, присылается Laas. Балансеры L7 используют его как один из источников данных для куки `is_gdpr_b`, когда он доступен.
