#include "cookie_headers.h"

#include <util/random/shuffle.h>

namespace NModCookiePolicy {
    bool TruncateDeletions(TVector<TSetCookie>& dels, ui32 hardMax) noexcept {
        if (dels.size() <= hardMax) {
            return false;
        }
        // So that every deletion has a chance to survive the pruning
        Shuffle(dels.begin(), dels.end());
        dels.resize(hardMax);
        return true;
    }
}
