#pragma once

#include "enums.h"

#include <balancer/modules/cookie_policy/common/cookie_policy.cfgproto.pb.h>

#include <balancer/kernel/cookie/set_cookie.h>
#include <balancer/kernel/http/parser/http.h>
#include <balancer/kernel/module/conn_descr.h>

#include <string>

namespace NModCookiePolicy {
    using namespace NSrvKernel;

    struct [[nodiscard]] TDomainInfo {
        TMaybe<std::string> Domain;
        TMaybe<std::string> DomainRoot;
        TMaybe<std::string> DomainWcard;
        bool IsSecure = false;
        bool IsGdpr = false;

    public:
        Y_BALANCER_TUPLE_EQ(
            TDomainInfo,
            TMaybe<TStringBuf>(Domain),
            TMaybe<TStringBuf>(DomainRoot),
            TMaybe<TStringBuf>(DomainWcard),
            IsSecure,
            IsGdpr
        )
    };


    class TDomainFilter {
    public:
        TDomainFilter() noexcept = default;

        TDomainFilter(const TDomainFilterCfg& cfg);

        explicit operator bool() const noexcept {
            return IncludeDomainsRe_ || ExcludeDomainsRe_;
        }

        [[nodiscard]]
        bool Included(const TDomainInfo& domainInfo) const noexcept;

        [[nodiscard]]
        bool Excluded(const TDomainInfo& domainInfo) const noexcept;

    private:
        TMaybe<TFsm> IncludeDomainsRe_;
        TMaybe<TFsm> ExcludeDomainsRe_;
    };


    TDomainInfo GetDomainInfo(const TConnDescr& descr) noexcept;
}
