#pragma once

#include <balancer/kernel/cookie/gdpr/gdpr.h>
#include <balancer/kernel/cookie/gdpr/is_gdpr_b.h>
#include <balancer/kernel/cookie/set_cookie.h>
#include <balancer/kernel/cookie/set_cookie_errors.h>

#include <util/generic/serialized_enum.h>

namespace NModCookiePolicy {
    using NSrvKernel::ESameSite;
    using NSrvKernel::TCookieErrors;
    using NSrvKernel::ESetCookieSyntaxError;
    using NGdprCookie::EGdpr;
    using NGdprCookie::EIsGdpr;
    using NGdprCookie::TIsGdprB;

    enum class EYandexPolicyMode {
        Off         /*"off"*/,
        WatchOnly   /*"watch_only", "stable"*/,
        StableFix   /*"stable_fix"*/,
        Unstable    /*"unstable"*/,
        FixAll      /*"fix_all"*/,
    };

    enum class EPolicyMode {
        Off     /*"off"*/,
        DryRun  /*"dry_run"*/,
        Fix     /*"fix"*/,
    };

    enum class EResponseCookieReason : ui32 {
        Deletion,
        NotSessionLifetime,
        NotPersistentLifetime,
        BigLifetime,
        SmallLifetime,
        BadDomain,
        WrongDomain,
        NotGlobalScope,
        ValueChange,
        BadValue,
        HttpOnly,
        NotSecure,
        Forbidden,
        BadSameSite,
        Conflict,
        Create,
        Update,
        GdprDelete,
        SoftLimited,
        HardLimited,
    };

    enum class ERequestCookieReason : ui32 {
        BadValue,
        Conflict,
        Create,
        Update,
    };

    enum class ECookieAction {
        Fix,
        Drop,
        Add
    };

    enum class EPolicyResult {
        Off,
        Skip,
        Pass,
        FailDryRun,
        FailFix
    };

    enum class EGdprSource {
        None,
        IsGdprB,
        XYandexEURequest,
        XIpProperties,
    };
}
