#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.cfgproto.pb.h>
#include <balancer/kernel/cookie/gdpr/is_gdpr_b.h>
#include <balancer/kernel/cookie/gdpr/cookie_type.h>

#include <util/generic/hash_set.h>
#include <util/generic/map.h>

namespace NModCookiePolicy {
    using namespace NSrvKernel;
    using namespace NGdprCookie;

    class TIsGdprBFilter {
    public:
        TIsGdprBFilter() = default;
        explicit TIsGdprBFilter(const TIsGdprBFilterCfg& fltr) noexcept;

        [[nodiscard]]
        bool Match(const TIsGdprB& isGdprB) const noexcept;

    private:
        TMap<TInstant, TInstant> TstampRanges_;
        THashSet<ui64> BalancerVerHashes_;
    };


    class TGdprControls {
    public:
        TGdprControlsCfg Cfg;
        TIsGdprBFilter BannedIsGdprB;
        TMaybe<TFsm> TechCookieRe;

    public:
        TGdprControls() = default;
        explicit TGdprControls(const TGdprControlsCfg& cfg) noexcept;
    };


    class TCookieClassifier {
    public:
        TCookieClassifier(const TGdprControls& cfg, const TGdprControls* dynCfg) noexcept;

        ECookieType GetCookieType(TStringBuf name) const noexcept;

    private:
        const TGdprControls& Cfg_;
        const TGdprControls* DynCfg_ = nullptr;
    };
}
