#pragma once

#include "domain_info.h"
#include "enums.h"

#include <balancer/modules/cookie_policy/common/cookie_policy.cfgproto.pb.h>

#include <util/generic/hash.h>

namespace NModCookiePolicy {
    using namespace NSrvKernel;

    class TModeControls : public TMoveOnly {
        struct TPolicyDomainMode {
            TMaybe<EPolicyMode> Mode;
            TDomainFilter DomainFilter;
        };

        struct TPolicyMode {
            TMaybe<EPolicyMode> Mode;
            TDeque<TPolicyDomainMode> DomainModes;

        public:
            TPolicyMode() noexcept = default;
            TPolicyMode(const TPolicyModeCfg& cfg) noexcept;

            TMaybe<EPolicyMode> GetMode(const TDomainInfo& domainInfo) const noexcept;
        };

    public:
        TModeControls() = default;

        TModeControls(const TModeControlsCfg& cfg) noexcept;

        [[nodiscard]]
        TMaybe<EPolicyMode> PolicyMode(TStringBuf name, const TDomainInfo& domainInfo) const noexcept;

        [[nodiscard]]
        TMaybe<EPolicyMode> ParserMode(const TDomainInfo& domainInfo) const noexcept;

    private:
        TPolicyMode ParserMode_;
        THashMap<TString, TPolicyMode> PolicyModes_;
    };
}
