#pragma once

#include "cookie_policy.h"
#include "stats.h"

#include <balancer/kernel/cookie/set_cookie.h>
#include <balancer/kernel/http/string_storage/string_storage.h>

#include <util/generic/vector.h>

namespace NModCookiePolicy {
    using namespace NSrvKernel;


    TVector<TRequestCookie> ParseRequestCookies(TArrayRef<const TStringStorage> rawHeaders) noexcept;


    TString RenderRequestCookies(const TVector<TRequestCookie>& cookies) noexcept;


    std::tuple<TVector<TResponseCookie>, TSetCookieParserErrors> ParseResponseCookies(
        TArrayRef<const TStringStorage> rawHeaders, bool dryRun, TGlobalStats& stats) noexcept;


    TVector<TStringStorage> RenderResponseCookies(
        const TVector<TResponseCookie>& cookies, TArrayRef<TStringStorage> prevHeaders) noexcept;
}
