#pragma once

#include "enums.h"

#include <balancer/modules/cookie_policy/common/enums.h_serialized.h>
#include <balancer/kernel/cookie/cookie_errors.h>

#include <util/generic/vector.h>

#include <string>

namespace NSrvKernel {
    class TRequest;
    class TResponse;
}

namespace NModCookiePolicy {
    using namespace NSrvKernel;

    TStringBuf ToStringBuf(ECookieAction a) noexcept;
    TStringBuf ToStringBuf(EPolicyResult a) noexcept;


    template <class TErrEnum>
    struct [[nodiscard]] TCookieAction {
        std::string Info;
        TCookieErrors<TErrEnum> Reasons;
        ECookieAction Action = ECookieAction::Fix;
        ui32 Count = 1;
    };

    using TRequestCookieReasons = TCookieErrors<ERequestCookieReason>;
    using TResponseCookieReasons = TCookieErrors<EResponseCookieReason>;

    using TSetCookieParserError = TCookieAction<ESetCookieSyntaxError>;
    using TRequestCookieAction = TCookieAction<ERequestCookieReason>;
    using TResponseCookieAction = TCookieAction<EResponseCookieReason>;

    using TSetCookieParserErrors = TVector<TSetCookieParserError>;
    using TRequestCookieActions = TVector<TRequestCookieAction>;
    using TResponseCookieActions = TVector<TResponseCookieAction>;


    TString LogPolicyResult(TStringBuf uuid, bool dryRun, const TRequestCookieActions&) noexcept;
    TString LogPolicyResult(TStringBuf uuid, bool dryRun, const TResponseCookieActions&) noexcept;
    TString LogParserResult(TStringBuf uuid, bool dryRun, const TSetCookieParserErrors &) noexcept;

    void MaybeReportCookieProblems(const TRequest& req, TResponse& resp, const TString& logs) noexcept;
}
