#include <balancer/modules/cookie_policy/common/controls_reader.h>
#include <balancer/modules/cookie_policy/common/cookie_policy.cfgproto.pb.h>
#include <balancer/modules/cookie_policy/common/gdpr_controls.h>
#include <balancer/modules/cookie_policy/ut_common/utils.h>

#include <balancer/kernel/testing/conn_descr.h>
#include <balancer/kernel/testing/process_mock.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NModCookiePolicy;
using namespace NSrvKernel::NTesting;


Y_UNIT_TEST_SUITE(TGdprControlsTest) {
    Y_UNIT_TEST(TestBadParse) {
        TProcessMock proc;
        TTestConnDescr descr(proc);
        auto ctl = ParseControls<TGdprControls, TGdprControlsCfg>(
            "x x x", "controls", "cookie_policy", descr.ConnDescr()
        );
        UNIT_ASSERT(!ctl);
    }

    void DoTestParse(TString data) {
        TProcessMock proc;
        TTestConnDescr descr(proc);

        {
            auto emptyCtl = ParseControls<TGdprControls, TGdprControlsCfg>(
                {}, "controls", "cookie_policy", descr.ConnDescr()
            );
            UNIT_ASSERT(emptyCtl->Cfg.use_x_ip_properties());
            UNIT_ASSERT(emptyCtl->Cfg.use_is_gdpr_b());
            UNIT_ASSERT(emptyCtl->Cfg.use_x_yandex_eu_request());
        }

        auto ctl = ParseControls<TGdprControls, TGdprControlsCfg>(
            data, "controls", "cookie_policy", descr.ConnDescr()
        );

        UNIT_ASSERT(ctl);
        UNIT_ASSERT(!ctl->Cfg.use_x_ip_properties());
        UNIT_ASSERT(!ctl->Cfg.use_is_gdpr_b());
        UNIT_ASSERT(!ctl->Cfg.use_x_yandex_eu_request());
        UNIT_ASSERT_VALUES_EQUAL(ctl->Cfg.deletion_limits().soft_max(), 13);
        UNIT_ASSERT_VALUES_EQUAL(ctl->Cfg.deletion_limits().hard_max(), 23);

        UNIT_ASSERT(!ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=789,
            .Tstamp=TInstant::Seconds(1599555555),
        }));
        UNIT_ASSERT(ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=123,
            .Tstamp=TInstant::Seconds(1599555555),
        }));
        UNIT_ASSERT(ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=456,
            .Tstamp=TInstant::Seconds(1599555555),
        }));
        UNIT_ASSERT(ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=789,
            .Tstamp=TInstant::Seconds(1599588888),
        }));
        UNIT_ASSERT(ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=123,
            .Tstamp=TInstant::Seconds(1599588888),
        }));
        UNIT_ASSERT(!ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=789,
            .Tstamp=TInstant::Seconds(1599587999),
        }));
        UNIT_ASSERT(!ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=789,
            .Tstamp=TInstant::Seconds(1599888888),
        }));
        UNIT_ASSERT(ctl->BannedIsGdprB.Match(TIsGdprB{
            .BalancerVerHash=789,
            .Tstamp=TInstant::Seconds(1600588888),
        }));
    }

    Y_UNIT_TEST(TestParseLua) {
        DoTestParse(R"=({
    use_x_ip_properties = 0;
    use_is_gdpr_b = 0;
    use_x_yandex_eu_request = 0;
    unknown_field_tolerance = "xxx";
    banned_is_gdpr_b = {
        unknown_field_tolerance = "xxx";
        items = {
            {
                unknown_field_tolerance = "xxx";
                tstamp_secs_begin = 1599588888;
                tstamp_secs_end   = 1599888888;
            };
            {
                balancer_ver_hash = 123;
                tstamp_secs_begin = 1600588888;
                tstamp_secs_end   = 1600888888;
            };
            {
                balancer_ver_hash = 456;
            };
        };
    };
    deletion_limits = {
        soft_max = 13;
        hard_max = 23;
    };
};)=");
    }

    Y_UNIT_TEST(TestParseJson) {
        DoTestParse(R"=({
    "use_x_ip_properties": 0,
    "use_is_gdpr_b": 0,
    "use_x_yandex_eu_request": 0,
    "unknown_field_tolerance": "xxx",
    "banned_is_gdpr_b": {
        "unknown_field_tolerance": "xxx",
        "items": [
            {
                "unknown_field_tolerance": "xxx",
                "tstamp_secs_begin": 1599588888,
                "tstamp_secs_end":   1599888888
            },
            {
                "balancer_ver_hash": 123,
                "tstamp_secs_begin": 1600588888,
                "tstamp_secs_end":   1600888888
            },
            {
                "balancer_ver_hash": 456
            }
        ]
    },
    "deletion_limits": {
        "soft_max": 13,
        "hard_max": 23
    }
})=");
    }
}
