#include "utils.h"

#include <util/string/join.h>

namespace NModCookiePolicy {
    TMaybe<NRegExp::TFsm> MaybeRe(const TString& re, bool has, NRegExp::TFsm::TOptions opts) {
        if (has) {
            return NRegExp::TFsm(re, opts);
        }
        return Nothing();
    }

    TString JoinNonemptySeq(TVector<TString> seq, TString sep) noexcept {
        EraseIf(seq, [](auto&& s) {
            return !s;
        });
        return JoinSeq(sep, seq);
    }
}
