#pragma once

#include <library/cpp/config/sax.h>
#include <library/cpp/proto_config/config.h>
#include <library/cpp/regex/pire/regexp.h>

#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>

namespace NModCookiePolicy {

#define Y_COOKIE_POLICY_CFG_OR_DYN(cfg, dyn, name) \
    ([](const auto& c, const auto* d) { \
        if (d && d->has_ ## name()) { \
            return d->name(); \
        } else { \
            return c.name(); \
        } \
    })(cfg, dyn)

#define Y_COOKIE_POLICY_CFG_OR_DYN_F(cfg, dyn, fld, name) \
    Y_COOKIE_POLICY_CFG_OR_DYN(cfg.fld, (const std::decay_t<decltype(cfg.fld)>*)(dyn ? &dyn->fld : nullptr), name)

    TMaybe<NRegExp::TFsm> MaybeRe(const TString& re, bool has, NRegExp::TFsm::TOptions opts = {});

    TString JoinNonemptySeq(TVector<TString> seq, TString sep="-") noexcept;
}
