#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

namespace NModCookiePolicy {
    class TPolicyGdprClientCookie final : public ICookiePolicy {
    public:
        TPolicyGdprClientCookie(TString name, const TPolicyGdprClientCookieCfg& cfg);

    private:
        THolder<IPolicyCustomCtx> NewCtx() const noexcept override;

        bool MatchRequest(const TPolicyArgs& args) const noexcept override;

        TRequestCookieActions ApplyToRequestCookies(
            TVector<TRequestCookie>& cookies, const TPolicyArgs& args) const noexcept override;

        void AddSetCookies(TSetCookiesCallback cb, const TPolicyArgs& args) const noexcept override;

    private:
        TPolicyGdprClientCookieCfg Cfg_;
    };
}
