#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

namespace NModCookiePolicy {
    class TPolicyGdprLifetime final : public ICookiePolicy {
    public:
        TPolicyGdprLifetime(TString name, const TPolicyGdprLifetimeCfg& cfg);

    private:
        bool MatchRequest(const TPolicyArgs&) const noexcept override;

        bool MatchResponseCookie(const TSetCookie& c, const TPolicyArgs& args) const noexcept override;

        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

    private:
        TPolicyGdprLifetimeCfg Cfg_;
    };
}
