#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

namespace NModCookiePolicy {
    class TPolicyGdprServerCookie final : public ICookiePolicy {
    public:
        TPolicyGdprServerCookie(TString name, const TPolicyGdprServerCookieCfg& cfg);

    private:
        bool MatchRequest(const TPolicyArgs&) const noexcept override;

        bool MatchResponseCookie(const TSetCookie& c, const TPolicyArgs& args) const noexcept override;

        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

    private:
        TPolicyGdprServerCookieCfg Cfg_;
    };
}
