#include "p_http_only_false.h"

namespace NModCookiePolicy {
    TPolicyHttpOnlyFalse::TPolicyHttpOnlyFalse(TString name, const TPolicyHttpOnlyFalseCfg& cfg)
        : TNameMatchPolicyBase(name, cfg, true)
    {}

    TMaybe<ICookiePolicy::TAction> TPolicyHttpOnlyFalse::ApplyToResponseCookie(
        TResponseCookieView c, const TPolicyArgs& args) const noexcept
    {
        if (c.Const().HttpOnly) {
            if (!args.DryRun) {
                c.Mutable().HttpOnly = false;
            }
            return TAction{.Reasons={EResponseCookieReason::HttpOnly}};
        }
        return Nothing();
    }
}
