#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

namespace NModCookiePolicy {

    class TPolicyIsGdprCookieBase : public ICookiePolicy {
    public:
        struct TArgs {
            TStringBuf Name;
            TBlob Value;
            ui32 Count = 0;
            bool BadParse = false;
        };
    protected:
        TPolicyIsGdprCookieBase(TString name, EPolicyMode mode);

    private:
        virtual TArgs Render(const TPolicyArgs& args) const noexcept = 0;
        virtual bool NeedUpdate(const TPolicyArgs& args) const noexcept = 0;

        bool MatchRequest(const TPolicyArgs& args) const noexcept override final;

        TRequestCookieActions ApplyToRequestCookies(
            TVector<TRequestCookie>& cookies, const TPolicyArgs& args) const noexcept override final;

        void AddSetCookies(TSetCookiesCallback cb, const TPolicyArgs& args) const noexcept override final;
    };


    class TPolicyIsGdprCookie final : public TPolicyIsGdprCookieBase {
    public:
        TPolicyIsGdprCookie(TString name, const TPolicyIsGdprCookieCfg& cfg);

    private:
        bool NeedUpdate(const TPolicyArgs& args) const noexcept override;

        TArgs Render(const TPolicyArgs& args) const noexcept override;
    };


    class TPolicyIsGdprBCookie final : public TPolicyIsGdprCookieBase {
    public:
        TPolicyIsGdprBCookie(TString name, const TPolicyIsGdprBCookieCfg& cfg);

    private:
        bool NeedUpdate(const TPolicyArgs& args) const noexcept override;

        TArgs Render(const TPolicyArgs& args) const noexcept override;
    };
}
