#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>
#include <balancer/kernel/cookie/gdpr/lifetime.h>

namespace NModCookiePolicy {
    class TPolicyPersistentLifetime final : public TNameMatchPolicyBase {
    public:
        TPolicyPersistentLifetime(TString name, const TPolicyPersistentLifetimeCfg& cfg);

    private:
        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

        THolder<IPolicyCustomTls> NewTls(TString /*uuid*/, TSharedStatsManager&) const noexcept override;

    private:
        const TPolicyPersistentLifetimeCfg Cfg_;
    };
}
