#include "p_protected_cookie.h"

namespace NModCookiePolicy {
    TPolicyProtectedCookie::TPolicyProtectedCookie(TString name, const TPolicyProtectedCookieCfg& cfg)
        : TNameMatchPolicyBase(name, cfg, true)
        , DomainsFilter_(cfg.domain_filter())
    {}

    bool TPolicyProtectedCookie::MatchRequest(const TPolicyArgs& args) const noexcept {
        return !DomainsFilter_ || DomainsFilter_.Included(args.DomainInfo) && !DomainsFilter_.Excluded(args.DomainInfo);
    }

    TMaybe<ICookiePolicy::TAction> TPolicyProtectedCookie::ApplyToResponseCookie(
        TResponseCookieView, const TPolicyArgs&) const noexcept
    {
        return TAction{
            .Reasons={EResponseCookieReason::Forbidden},
            .Action=ECookieAction::Drop,
        };
    }
}
