#pragma once

#include <balancer/modules/cookie_policy/common/cookie_policy.h>

#include <balancer/kernel/regexp/regexp_pire.h>

namespace NModCookiePolicy {
    class TPolicySameSiteNone final : public ICookiePolicy {
    public:
        TPolicySameSiteNone(TString name, const TPolicySameSiteNoneCfg& cfg);

    private:
        bool MatchResponseCookie(const TSetCookie& c, const TPolicyArgs&) const noexcept override;

        TMaybe<TAction> ApplyToResponseCookie(TResponseCookieView c, const TPolicyArgs& args) const noexcept override;

    private:
        const TPolicySameSiteNoneCfg Cfg_;
        const TMaybe<TFsm> NameRe_;
    };
}
